/*
 *  THUMCtl.h
 *  THUMCtl
 *
 *  Created by Rich Inacker on 9/2/06.
 *
 */

#ifndef THUMCtl_H

#define THUMCtl_H

/* ------------------------------------------------------------------------------------- */
/* Error Codes - THUM General Codes                                                      */
#define THUM_ERROR_SUCCESS          0      /* No error */
#define THUM_ERROR_BADTEMPUNIT      1      /* Bad temperature unit (not F, f, C, or c) */
#define THUM_ERROR_THUMNOTFOUND     2      /* THUM device not found */
#define THUM_ERROR_READTIMEOUT      3      /* Read operation timed out */
#define THUM_ERROR_WRITEFAILED      4      /* Write operation failed */
#define THUM_ERROR_READFAILED       5      /* Read operation failed */
#define THUM_ERROR_RESULTOUTOFRANGE 6      /* Temp or RH was out of range */
#define THUM_ERROR_PARAMOUTOFRANGE  7      /* Parameter was out of range */
/* ------------------------------------------------------------------------------------- */
/* Error Codes - THUM Mac-specific Codes start at 64                                     */
#define THUM_ERROR_CANTACCESS		64		/* Can't access the THUM device */
#define THUM_ERROR_NOTSUPPORTED		65		/* Sensor not supported on this THUM */
#define THUM_ERROR_BADSENSOR		66		/* Sensor bad or not connected */
/* ------------------------------------------------------------------------------------- */
/* Various constants and info                                                            */
#define THUMCTL_MAC_VERSION			"1.1.0"
#define THUM_TRUE					1
#define THUM_FALSE					0
#define MUST_MEASURE				-999.9	/* Token passed to RH/DP functs */
/* ------------------------------------------------------------------------------------- */
/* Functions                                                                             */
extern void printErrorDescriptor (int descriptor);
extern int GetTemp(double *returnValue, unsigned char unitAddress);
extern int GetRH(double *returnValue, double tempC, unsigned char unitAddress);
extern int GetDP(double *returnValue, double tempC, double RH, unsigned char unitAddress);
extern int GetExternalTemp(double *returnValue, unsigned char unitAddress);
extern int GetIR(double *returnValue, unsigned char unitAddress);
extern int GetUltrasonic(double *returnValue, unsigned char unitAddress);
extern int GetSwitch(double *returnValue, unsigned char unitAddress);
extern int GetSwitch2(double *returnValue, unsigned char unitAddress);
extern int GetSwitch3(double *returnValue, unsigned char unitAddress);
extern int ResetTHUM(unsigned char unitAddress);
extern int GetSecondaryInternalTemp(double *returnValue, unsigned char unitAddress);
/* ------------------------------------------------------------------------------------- */

#endif
