/*
 *  THUMLibPrivate.h
 *
 *	Note: This file contains proprietary information.
 *
 *  This file is not to be disclosed to third parties without the express written consent of
 *	Practical Solutions, Inc. (Yankton, SD).
 *
 */

#ifndef THUMLibPrivate_H
#define THUMLibPrivate_H

#include <IOKit/IOCFPlugIn.h>
#include <IOKit/hid/IOHIDKeys.h>
#include <IOKit/hid/IOHIDLib.h>
#include <CoreFoundation/CoreFoundation.h>

/* vendor and product IDs for the THUM device */
#define THUM_LIB_VERSION			"1.1"
#define THUM_VENDORID				0x0C70
#define THUM_PRODID					0x0750
#define READTRIES					20				/* Number of attempts to readback data before raising error */

#define NODATA						0xFF
#define SHT75_MISSING				0x0000			/* Internal SHT75 missing or bad */
#define SHT75_MIN_TEMP_C			-40.0			/* Lowest valid temperature (C) for SHT75 */
#define SHT75_MAX_TEMP_C			51.0			/* Highest valid temperature (C) for SHT75 */
#define SHT75_MIN_RH				0				/* Lowest valid humidity for SHT75 */
#define SHT75_MAX_RH				100				/* Highest valid humidity for SHT75 */

#endif