/*
 *  IntReportDescriptors.h
 *  THUMCtl
 *
 *  Created by Rich Inacker on 9/13/06.
 *
 *	Note: This file contains proprietary information.
 *
 *  This file is not to be disclosed to third parties without the express written consent of
 *	Practical Solutions, Inc. (Yankton, SD).
 *
 */

#ifndef IntReportDescriptors_H

#define IntReportDescriptors_H

/* ---------------------------------------------------------------------------------------------- */
/* Interrupt Report Selectors                                                                     */
#define	THUM_READ_INTERNAL_T			0x00	/* Read Temp from SHT75 */
#define THUM_READ_INTERNAL_RH			0x01	/* Read RH from SHT75 */
#define THUM_READ_INTERNAL_REG			0x02	/* Read Internal Register */
#define THUM_RESET						0x03	/* Reset THUM Hardware */
#define THUM_READ_IR_PROX				0x04	/* Read IR Proximity Sensor */
#define THUM_CHECK_IR_PROX				0xF4	/* Check IR Proximity Sensor */
#define THUM_READ_LM61					0x05	/* Read LM61 Temperature Sensor */
#define THUM_READ_SWITCH_3				0x06	/* Read Switch Connected to Socket 3 */
#define THUM_READ_US_PROX				0x07	/* Read Ultrasonic Proximity Sensor */
#define THUM_CHECK_US_PROX				0xF7	/* Check Ultrasonic Proximity Sensor */
#define THUM_READ_INTERNAL_DALLAS		0x08	/* Read Internal Dallas Temp Sensor */
#define THUM_CHECK_INTERNAL_DALLAS		0xF8	/* Check Internal Dallas Temp Sensor */
#define THUM_READ_SOCKET2_DALLAS		0x09	/* Read Socket 2 Dallas DS1822 Temp Sensor */
#define THUM_CHECK_SOCKET2_DALLAS		0xF9	/* Check Socket 2 Dallas DS1822 Temp Sensor */
#define THUM_READ_SWITCH_2				0x0A	/* Read Switch Connected to Socket 2 */
#define THUM_READ_SWITCH_1				0x0B	/* Read Switch Connected to Socket 1 */
/* ---------------------------------------------------------------------------------------------- */
/* Sanity Checkers															                      */
#define SHT75_MISSING					0x0000	/* Internal SHT75 missing or bad */
#define IR_PROX_MISSING					0x0000	/* IR proximity sensor missing or bad */
#define IR_PROX_NOTSUPPORTED_1			0x0400	/* IR proximity sensor not supported */
#define IR_PROX_NOTSUPPORTED_2			0x0401	
#define LM35_MISSING					0x00FF	/* LM35 missing or bad */
#define SWITCH_3_NOTSUPPORTED			0x0600	/* Switch on socket 3 not supported on this THUM */
#define SWITCH_2_NOTSUPPORTED			0x0A00	/* Switch on socket 2 not supported on this THUM */
#define SWITCH_1_NOTSUPPORTED			0x0B00	/* Switch on socket 1 not supported on this THUM */
#define US_PROX_MISSING					0x0000	/* Ultasonic proximity sensor missing or bad */
#define US_PROX_NOTSUPPORTED_1			0x0700	/* Ultasonic proximity sensor not supported */
#define US_PROX_NOTSUPPORTED_2			0x0701
#define DS1822_MISSING					0xFF83	/* DS1822 temp sensor missing or bad */
#define DS1822_INTERNAL_NOTSUPPORTED_1	0x0800	/* Internal DS1822 temp sensor not supported */
#define DS1822_INTERNAL_NOTSUPPORTED_2	0x0801
#define DS1822_REMOTE_NOTSUPPORTED_1	0x0900	/* External DS1822 temp sensor not supported */
#define DS1822_REMOTE_NOTSUPPORTED_2	0x0901
/* ---------------------------------------------------------------------------------------------- */

#endif