/*
 *  THUMLib.h
 *
 *
 */

#ifndef THUMLib_H
#define THUMLib_H

/* Error Codes - THUM General Codes */
#define THUM_ERROR_SUCCESS          0      /* No error */
#define THUM_ERROR_BADTEMPUNIT      1      /* Unused (for compatibility with Win32 versions) */
#define THUM_ERROR_THUMNOTFOUND     2      /* THUM device not found */
#define THUM_ERROR_READTIMEOUT      3      /* Read operation timed out */
#define THUM_ERROR_WRITEFAILED      4      /* Write operation failed */
#define THUM_ERROR_READFAILED       5      /* Read operation failed */
#define THUM_ERROR_RESULTOUTOFRANGE 6      /* Temp or RH result was out of range */
#define THUM_ERROR_PARAMOUTOFRANGE  7      /* Parameter was out of range */

/* Error Codes - THUM Mac-specific Codes start at 64 */
#define THUM_ERROR_CANTACCESS		64		/* Can't access the THUM device */
#define THUM_ERROR_NOTSUPPORTED		65		/* Sensor not supported on this THUM */
#define THUM_ERROR_BADSENSOR		66		/* Sensor bad or not connected */

/* Public Functions */
extern int GetTHUMDylibVersion (char *dylibVersionString, int stringSize);
extern int GetTHUMHandle(void *THUMHandle, UInt32 unitAddress, IOHIDCallbackFunction RemovalReportCallback);
extern int ReadTHUM(void *THUMHandle, double *tempC, double *rh);
extern int ReleaseTHUMHandle(void *THUMHandle);
extern int ResetTHUM(void *THUMHandle);

#endif